/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.math.BigInteger;

public final class BigInt {
    private byte[] places;
    private static final String digits = "0123456789abcdef";

    public int hashCode() {
        return this.hexify().hashCode();
    }

    public int toInt() {
        if (this.places.length > 4) {
            throw new NumberFormatException("BigInt.toLong, too big");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.places.length; ++i2) {
            n2 = (n2 << 8) + (this.places[i2] & 0xFF);
        }
        return n2;
    }

    public byte[] toByteArray() {
        return (byte[])this.places.clone();
    }

    public BigInt(int n2) {
        if (n2 < 256) {
            this.places = new byte[1];
            this.places[0] = (byte)n2;
        } else if (n2 < 65536) {
            this.places = new byte[2];
            this.places[0] = (byte)(n2 >> 8);
            this.places[1] = (byte)n2;
        } else if (n2 < 0x1000000) {
            this.places = new byte[3];
            this.places[0] = (byte)(n2 >> 16);
            this.places[1] = (byte)(n2 >> 8);
            this.places[2] = (byte)n2;
        } else {
            this.places = new byte[4];
            this.places[0] = (byte)(n2 >> 24);
            this.places[1] = (byte)(n2 >> 16);
            this.places[2] = (byte)(n2 >> 8);
            this.places[3] = (byte)n2;
        }
    }

    public BigInt(byte[] byArray) {
        this.places = (byte[])byArray.clone();
    }

    public boolean equals(Object object) {
        if (object instanceof BigInt) {
            return this.equals((BigInt)object);
        }
        return false;
    }

    private String hexify() {
        if (this.places.length == 0) {
            return "  0  ";
        }
        StringBuffer stringBuffer = new StringBuffer(this.places.length * 2);
        stringBuffer.append("    ");
        for (int i2 = 0; i2 < this.places.length; ++i2) {
            stringBuffer.append(digits.charAt(this.places[i2] >> 4 & 0xF));
            stringBuffer.append(digits.charAt(this.places[i2] & 0xF));
            if ((i2 + 1) % 32 == 0) {
                if (i2 + 1 == this.places.length) continue;
                stringBuffer.append("\n    ");
                continue;
            }
            if ((i2 + 1) % 4 != 0) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.hexify();
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.places);
    }

    public BigInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if ((byArray[0] & 0x80) != 0) {
            throw new IllegalArgumentException("negative BigInteger");
        }
        if (byArray[0] != 0) {
            this.places = byArray;
        } else {
            this.places = new byte[byArray.length - 1];
            for (int i2 = 1; i2 < byArray.length; ++i2) {
                this.places[i2 - 1] = byArray[i2];
            }
        }
    }

    public boolean equals(BigInt bigInt) {
        if (this == bigInt) {
            return true;
        }
        byte[] byArray = bigInt.toByteArray();
        if (this.places.length != byArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.places.length; ++i2) {
            if (this.places[i2] == byArray[i2]) continue;
            return false;
        }
        return true;
    }
}

